# 全排列 II
<p>给定一个可包含重复数字的序列 <code>nums</code> ，<strong>按任意顺序</strong> 返回所有不重复的全排列。</p><p> </p><p><strong>示例 1：</strong></p><pre><strong>输入：</strong>nums = [1,1,2]<strong><br />输出：</strong>[[1,1,2], [1,2,1], [2,1,1]]</pre><p><strong>示例 2：</strong></p><pre><strong>输入：</strong>nums = [1,2,3]<strong><br />输出：</strong>[[1,2,3],[1,3,2],[2,1,3],[2,3,1],[3,1,2],[3,2,1]]</pre><p> </p><p><strong>提示：</strong></p><ul>	<li><code>1 <= nums.length <= 8</code></li>	<li><code>-10 <= nums[i] <= 10</code></li></ul>
<p>以下错误的选项是？</p>
## aop
### before
```cpp
#include <bits/stdc++.h>
using namespace std;
```
### after
```cpp
int main()
{
    Solution sol;
    vector<int> nums = {1, 1, 2};
    vector<vector<int>> res;

    res = sol.permuteUnique(nums);

    for (auto i : res)
    {
        for (auto j : i)
            cout << j << " ";
        cout << endl;
    }
    return 0;
}
```

## 答案
```cpp
class Solution
{
private:
    vector<vector<int>> result;
    vector<int> path;
    void backtracking(vector<int> &nums, vector<bool> &used)
    {

        if (path.size() == nums.size())
        {
            result.push_back(path);
            return;
        }
        for (int i = 0; i < nums.size(); i++)
        {
            if (used[i] == false)
            {
                used[i] = true;
                path.push_back(nums[i]);
                backtracking(nums, used);
                path.pop_back();
                used[i] = false;
            }
        }
    }

public:
    vector<vector<int>> permuteUnique(vector<int> &nums)
    {
        result.clear();
        path.clear();
        sort(nums.begin(), nums.end());
        vector<bool> used(nums.size(), false);
        backtracking(nums, used);
        return result;
    }
};
```
## 选项

### A
```cpp
class Solution
{
public:
    vector<vector<int>> permuteUnique(vector<int> &nums)
    {
        vector<vector<int>> res;
        int n = nums.size();
        vector<int> temp;
        vector<bool> visited(n, false);
        sort(nums.begin(), nums.end());
        backtrackpermuteUnique(0, n, nums, temp, res, visited);
        return res;
    }

    void backtrackpermuteUnique(int k, int n, vector<int> nums, vector<int> &temp, vector<vector<int>> &res, vector<bool> &visited)
    {
        if (k == n)
        {
            res.push_back(temp);
            return;
        }
        for (int i = 0; i < n; i++)
        {
            if (!visited[i])
            {
                if (i > 0 && nums[i] == nums[i - 1] && visited[i - 1])
                    continue;
                temp.push_back(nums[i]);
                visited[i] = true;
                backtrackpermuteUnique(k + 1, n, nums, temp, res, visited);

                temp.pop_back();
                visited[i] = false;
            }
        }
    }
};
```

### B
```cpp
class Solution
{
public:
    vector<vector<int>> permuteUnique(vector<int> &nums)
    {
        vector<vector<int>> res;
        vector<bool> used(nums.size());
        sort(nums.begin(), nums.end());
        dfs(nums, used, res);
        return res;
    }

private:
    vector<int> stack;
    void dfs(vector<int> &nums, vector<bool> &used, vector<vector<int>> &res)
    {
        if (stack.size() == nums.size())
        {
            res.push_back(stack);
        }
        else
        {
            for (int i = 0; i < nums.size(); i++)
            {
                if (!used[i])
                {
                    if (i > 0 && !used[i - 1] && nums[i - 1] == nums[i])
                    {
                        continue;
                    }
                    stack.push_back(nums[i]);
                    used[i] = true;
                    dfs(nums, used, res);
                    stack.pop_back();
                    used[i] = false;
                }
            }
        }
    }
};
```

### C
```cpp

class Solution
{
public:
    vector<vector<int>> permuteUnique(vector<int> &nums)
    {
        vector<int> now_p;
        vector<vector<int>> all_p;
        vector<pair<int, int>> numCnt;

        sort(nums.begin(), nums.end());
        for (int i = 0; i < nums.size();)
        {
            int num = nums[i], cnt = 1;
            while (i + cnt < nums.size() && nums[i + cnt] == num)
                ++cnt;
            i += cnt;
            numCnt.emplace_back(num, cnt);
        }

        function<void(int index)> generate;
        generate = [&generate, &nums, &numCnt, &now_p, &all_p](int index)
        {
            if (index == nums.size())
            {
                all_p.push_back(now_p);
                return;
            }

            for (auto &i : numCnt)
            {
                if (i.second)
                {
                    --i.second;
                    now_p.emplace_back(i.first);
                    generate(index + 1);
                    now_p.pop_back();
                    ++i.second;
                }
            }
        };

        generate(0);
        return all_p;
    }
};

```
